// Autor: Ivan Katanic

#include <algorithm>
#include <cassert>
#include <cstring>
#include <iostream>
#include <tuple>

using namespace std;

const int MAX = 200020;
const int off = 1<<18;
const int inf = 1e9;

// minmax tournament
pair<int, int> T[2*off];

pair<int, int> minmax(const pair<int, int>& a, const pair<int, int>& b) {
  return make_pair(min(a.first, b.first), max(a.second, b.second));
}

pair<int, int> getMinMax(int i, int lo, int hi, int a, int b) {
  if (lo >= b || hi <= a) return {+inf, -inf};
  if (lo >= a && hi <= b) return T[i];
  return minmax(
    getMinMax(i*2, lo, (lo+hi)/2, a, b),
    getMinMax(i*2+1, (lo+hi)/2, hi, a, b)
  );
}

void update(int y, int val) {
  y += off;
  if (val == -1) {
    T[y] = {+inf, -inf};
  } else {
    T[y] = {val, val};
  }
  for (y /= 2; y; y /= 2)
    T[y] = minmax(T[y*2], T[y*2+1]);
}



struct Daska {
  int x1, y1, x2, y2;
};

vector<pair<int, int>> horizontal[MAX]; // horizontal[y] = lista parova (x2, idx)
vector<pair<int, int>> vertical[MAX]; // vertical[x] = list of pairs (y2, idx)
Daska d[MAX];

struct Event {
  enum Type {
    HORIZONTAL_START,
    VERTICAL,
    HORIZONTAL_END,
  };
  
  int x, idx;
  Type type;

  friend bool operator < (const Event& a, const Event& b) {
    return tie(a.x, a.type, a.idx) < tie(b.x, b.type, b.idx);
  }
};

vector<Event> events;
bool active[MAX];


int comp_id[MAX]; // comp_id[i] = oznaka komponente segmenta i
vector<int> comp[MAX]; // comp[i] = lista segmenata u komponenti i

void mergeComps(int a, int b) {
  if (a == b) return;
  if (comp[a].size() < comp[b].size()) swap(a, b);

  for (int x : comp[b]) {
    comp[a].push_back(x);
    comp_id[x] = a;
    if (active[x]) update(d[x].y1, a);
  }
  comp[b].clear();
}


int findDaskaOfPoint(int x, int y) {
  auto it = lower_bound(horizontal[y].begin(), horizontal[y].end(), make_pair(x, -1));
  if (it != horizontal[y].end() && d[it->second].x1 <= x) return it->second;

  it = lower_bound(vertical[x].begin(), vertical[x].end(), make_pair(y, -1));
  if (it != vertical[x].end() && d[it->second].y1 <= y) return it->second;

  assert(false);
}

int main(void) {
  int N;
  scanf("%d", &N);
  for (int i = 0; i < N; ++i) {
    int x1, y1, x2, y2;
    scanf("%d %d %d %d", &x1, &y1, &x2, &y2);
    
    if (x1 == x2) {
      if (y1 > y2) swap(y1, y2);
      vertical[x1].push_back({y2, i});

      events.push_back({x1, i, Event::Type::VERTICAL});
    } else {
      if (x1 > x2) swap(x1, x2);
      horizontal[y1].push_back({x2, i});

      events.push_back({x1, i, Event::Type::HORIZONTAL_START});
      events.push_back({x2, i, Event::Type::HORIZONTAL_END});
    } 

    d[i] = {x1, y1, x2, y2};
  }

  for (int i = 0; i < MAX; ++i) {
    sort(vertical[i].begin(), vertical[i].end());
    sort(horizontal[i].begin(), horizontal[i].end());
  }
  
  // prvo nadjemo komponente
  sort(events.begin(), events.end());
  for (int i = 0; i < 2*off; ++i) T[i] = {+inf, -inf};
  for (int i = 0; i < N; ++i) {
    comp_id[i] = i;
    comp[i] = {i};
    active[i] = false;
  }

  for (Event& event: events) {
    if (event.type == Event::Type::HORIZONTAL_START) {
      update(d[event.idx].y1, comp_id[event.idx]);
      active[event.idx] = true;
    } else if (event.type == Event::Type::HORIZONTAL_END) {
      update(d[event.idx].y1, -1);
      active[event.idx] = false;
    } else if (event.type == Event::Type::VERTICAL) {
      int y1 = d[event.idx].y1;
      int y2 = d[event.idx].y2;

      // spoji u istu komponentu trenutnu liniju i sve aktivne horizontalne iz intervala [y1, y2]
      while (true) {
        pair<int, int> minmaxcomp = getMinMax(1, 0, off, y1, y2+1);
        if (minmaxcomp.first == inf) break; // nema aktivnih horizontalnih

        if (minmaxcomp.first != comp_id[event.idx]) {
          mergeComps(minmaxcomp.first, comp_id[event.idx]);
        } else if (minmaxcomp.second != comp_id[event.idx]) {
          mergeComps(minmaxcomp.second, comp_id[event.idx]);
        } else {
          break;
        }
      }
    } else {
      assert(false);
    }
  }
  
  int Q;
  scanf("%d", &Q);
  for (int i = 0; i < Q; ++i) {
    int x1, y1, x2, y2;
    scanf("%d %d %d %d", &x1, &y1, &x2, &y2);

    int a = findDaskaOfPoint(x1, y1);
    int b = findDaskaOfPoint(x2, y2);

    puts(comp_id[a] == comp_id[b] ? "DA" : "NE");
  }

  return 0;
}
